c     **** determins families then genera then species by expansion ****
c
c     **** parameters:  m, n, flag, list ****
c
c	   m= nber sites
c	   n= nber bonders to those sites
c	   flag= '-' (default) - dumps species and genera
c		 'n' - outputs genera file only  (saves disk)
c		 'g' - outputs genera file only, but also the number of genera are not evaluated (saves sisk and time) 
c	   list of m values stating the max number of bonds that each binding site can sustain (default is n)
c
c     **** family(m) = how many binders link to 1..m sites 
c     **** genus() continuous list tells for each binder the sites that it binds to ****
c     **** ngenus(binder) tells how many sites each binder binds to in the genus ****
c     **** igenus(binder) tells the index into genus of the first site for this ligand
c
c     **** alas genus generation code includes duplicated owing to Dnh rotation and reflection ****
c     **** so the genus is encoded into a 64-bit string and stored for comparison to canonical forms
c     **** 3 bits are used, so absolute max value of m is 8 !!!!! ***
c     **** hence there cant be more than 21 conenctions ... coding connection holes will allow S8B8 to be done ****

      implicit integer (a-z)
      parameter (mb=8, mf=2*mb, mgstor=100000)
      integer f(0:mf),family(mb),genus(16)
      integer*8 gstor(mgstor),g,gr
      logical hgenus,dumpspecies,getspecies,nextfamily,nextgenus,unmatched
      character*200 line,lineg
      character*30 fmat
      character*3 dmh

      common /ggenus/ nsl,nslmax,ngenus(mb),igenus(mb),hgenus(mb),
     $   genus0(16),smax(16),aftersites(16),getbinder(16),list(0:mb)

      common /eencode/ c
      common /fulldump/ dumpspecies

      call getarg (1,line)
      read (line,*) m
      write (dmh,'(a,i1,a)') 'D',m,'h'
      call getarg (2,line)
      read (line,*) n

      getspecies= .true.
      if (nargs().ge.4) then
	call getarg (3,line)
	getspecies= line(1:1).ne.'g'
      end if
      write (6,*) 'flag get_species=',getspecies

      dumpspecies= .true.
      if (nargs().ge.4) then
	call getarg (3,line)
	dumpspecies= line(1:1).eq.'-'
      end if
      write (6,*) 'flag dump_species=',dumpspecies

      list= n
      lineg= ' '
      if (nargs().ge.4+m) then
	lineg= '_max'
	im= 4
	do k= 0,m-1
	  call getarg (4+k,line)
	  read (line,*) list(k)
	  im= im + 1
	  lineg(im:im)= line(1:1)
	end do
      end if
      write (6,'(a,20i3)') 'Max nber of bonds at each site=',
     $			   (list(k),k=0,m-1)
      maxbtot= 0
      do i= 0,m-1
	maxbtot= maxbtot + list(i)
      end do
      write (6,*) 'Max total nber of bonds=',maxbtot

      if (lineg.eq.' ') then
        write (line,'(a,i1,a,i1,a)') 'genera_'//dmh//'_S',m,'B',n,'.txt'
      else
        write (line,'(a,i1,a,i1,a)') 'genera_'//dmh//'_S',m,'B',n,
     $					lineg(1:im)//'.txt'
      end if
      write (6,'(2a)') ' genera written to: ',line(1:len_trim(line))
      open (2,file=line(1:len_trim(line)))
      i= 12

      if (dumpspecies) then
        if (lineg.eq.' ') then
          write (line,'(a,i1,a,i1,a)') 'species_'//dmh//'_S',
     $					m,'B',n,'.txt'
        else
          write (line,'(a,i1,a,i1,a)') 'species_'//dmh//'_S',
     $					m,'B',n,lineg(1:im)//'.txt'
	end if
        write (6,'(2a)') 'species written to: ',line(1:len_trim(line))
        open (3,file=line(1:len_trim(line)))
	i= 9
      end if

      do io= 2,3
	if (.not.dumpspecies) cycle
        write (io,'(a)') line(i:i+3)
        write (io,'(a)') dmh //
     $		' site symmetry is used to group species into genera'
        write (io,'(a)') '====' 
        write (io,*)
      end do

c     **** n! ****
      f(0)= 1
      do i= 1,mf
	f(i)= f(i-1) * i
      end do

c     **** n! permutations of binders ****
      call getperm (n)

c     *** 4 bit encoding for genus = bod/hole flag + m=8 site possibilities ****
      c= 4

c     **** loop over families  ****

      nf= 0
      ns= 0
      ngtot= 0
      nstot= 0
      nslmax= 0
      family= -1

      do while (nextfamily(m,n,family))

	nbfamily= 0
	do i= 1,m
	  nbfamily= nbfamily + i*family(i)
	end do
	if (nbfamily.gt.maxbtot) cycle

	do io= 2,6
	  if (io.eq.4 .or. io.eq.5) cycle
	  write (io,'(a,20i2)') 'family=',(family(i),i=1,m)
	  write (io,*)
	end do

c	**** loop over genera for this family ****

	ng= 0
	ngenus= -1
        do while (nextgenus(m,n,family,genus))
C	  write (6,'(a,20i2)') 'nextgenus returns:',(genus(i),i=1,nsl)
	  call encode (g,m,n,family,genus)
	  if (unmatched(g,gstor,ng,m,family)) then
C	    write (6,'(i4,a,z17.16,z9.8)') ng+1,' new genus=',g

C	    write (fmat,'(a,i1,a,i2,a)') '(a,',m,'i2,a,i7,a,o22.',nsl,')'
C	    write (6,fmat) 'family=',(family(i),i=1,m),
C     $		' new '//dmh//' genus #',ng,' =',g
C	    write (2,fmat) 'family=',(family(i),i=1,m),
C     $		' new '//dmh//' genus #',ng,' =',g

	    call printfmat (lineg,nline,genus,family,m,n,
     $					igenus,ngenus,hgenus)

c	    **** abort if max bonds to some site test failed ****
	    if (lineg.eq.' ') cycle

	    ng= ng + 1
	    ngtot= ngtot + 1
	    if (ng.gt.mgstor) stop 'storage mgstor exceeded'
	    gstor(ng)= g

	    if (getspecies) then

	      write (fmat,'(a,i1,a)') '(a,',m,'i2,a,i6,2a)'
	      write (3,fmat) 'family=',(family(i),i=1,m),
     $		  ' new '//dmh//' genus #',ng,' is ',lineg(1:nline)

	      call species (line,genus,family,m,n,ns1)
	      ns= ns + ns1

	      write (fmat,'(a,i1,a)') '(a,',m,'i2,a,i6,a,i5,2a)'
	      do io= 2,6,4
	        write (io,fmat) 'family=',(family(i),i=1,m),
     $		  ' new '//dmh//' genus #',ng,
     $		  ' with ',ns1,' species is ',lineg(1:nline)
	      end do

	    else 
	      write (fmat,'(a,i1,a)') '(a,',m,'i2,a,i6,2a)'
	      do io= 2,6,4
	        write (io,fmat) 'family=',(family(i),i=1,m),
     $		  ' new '//dmh//' genus #',ng,' is ',lineg(1:nline)
	      end do

	    end if

	    
	  else
C	    write (6,'(a,20i2)') ' matched genus:',(genus(i),i=1,nsl)
	  end if

	end do

	do io= 2,6
	  if (io.eq.4.or.io.eq.5 .or. io.eq.3.and..not.getspecies) cycle
	  write (io,'(a,i5)') 'Nber of genera for this family=',ng
	  write (io,*)
	end do

c	**** count only families with active genera ****
	if (ng.gt.0) nf= nf + 1

      end do

      nfcalc= f(n+m-1) / f(m-1) / f(n)
      nscalf= (2**m-1)**n
      do io= 0,6
        if (io.eq.1 .or. io.eq.4 .or. io.eq.5) cycle
        write (io,'(40(1h-)/)')
        write (io,'(a,i7)') 'Nber families=',nf
        write (io,'(a,i9)') 'Nber genera=',ngtot
        if (getspecies) write (io,'(a,2i9)') 'Nber species=',ns
      end do
C      write (6,'(a,i3)') 'max nber of bonds in any genera=',nslmax

      end

c     ******************************************************************

      function nextfamily (m,n,family)

c     **** generates the next family, returns false when no more ****

      implicit integer (a-z)
      parameter (mb=8)
      integer family(m),maxb(mb)
      logical nextfamily
      common /ffamily/ maxb

      nextfamily= .true.

      if (family(1).eq.-1) then
	family= 0
	family(1)= n
	maxb= n
	return
      end if

      if (m.eq.1) then
c	**** there is only one family if m=1 ****
        nextfamily= .false.
	return
      end if

c     **** decrament ind, incrament ind+1 ****

      ind= 1
      family(ind)= family(ind) - 1
      family(ind+1)= family(ind+1) + 1

      do while (family(ind+1).gt.maxb(ind+1))
	if (ind.eq.m-1) then
c	  **** no more families ****
	  nextfamily= .false.
	  return
	end if
	ind= ind + 1
        family(ind+1)= family(ind+1) + 1
	do i= 1,ind
	  family(i)= 0
	  maxb(i)= maxb(ind+1) - family(ind+1)
	end do
	family(1)= maxb(1)
      end do

      return
      end

c     ******************************************************************

      function nextgenus (m,n,family,genus)

c     **** generates the next genus in this family, returns false when no more ****

      implicit integer (a-z)
      parameter (mb=8)
      integer family(m),genus(16)
      logical nextgenus,nextsitepattern,hgenus
      common /ggenus/ nsl,nslmax,ngenus(mb),igenus(mb),hgenus(mb),
     $   genus0(16),smax(16),aftersites(16),getbinder(16),list(0:mb)

c     **** hgenus(lig)= true if the sites are bond-hole stes, flase if they are bond sites
c     **** ngenus(lig)= how many sites for this ligand ****
c     **** igenus(lig)= index of the first site for this ligand ****
c     **** genus() = continual list of all assigned sites ****
c     **** nsl= total number of sites referred to in this genus ****
c     **** aftersites()= numb of sites after this that the ligand also bind too
c     **** getbinder()= binder attached to this binding site ****
c     **** smax sets the absolute value of the site on this index
c	 	smax(1)= 0 forces the first ligand to be on site 0
c		other limitations set by symmetry and by need for asc. order

      nextgenus= .true.

      if (ngenus(1).eq.-1) then
c	**** starting genus ****
	nlig= 0
	nsl= 0
	do ifamily= 1,m
	  do ilig= 1,family(ifamily)
	    nlig= nlig + 1
	    igenus(nlig)= nsl+1
	    hgenus(nlig)= ifamily.gt.m/2
	    if (hgenus(nlig)) then
	      ngenus(nlig)= m - ifamily
	    else
	      ngenus(nlig)= ifamily
	    end if
	    do isite= 1,ngenus(nlig)
	      nsl= nsl + 1
	      if (nsl.gt.16) then
	         write (0,*) 'nber sites in this genus=',nsl,' is > 16'
	         stop '64-bit word with 4-bit bond/hole encoding'
	      end if
c	      **** number sites from 0 to m-1 to manifest symmetry better ****
	      genus(nsl)= isite - 1
	      aftersites(nsl)= ngenus(nlig) - isite
	      getbinder(nsl)= ilig
C	      write (6,'(a,10i3)') 'ifam,fam,ilig,nsl,genus,aftersites=',
C     $	      ifamily,family(ifamily),ilig,nsl,genus(nsl),aftersites(nsl)
	    end do
	  end do
	end do

	genus0= genus
C	write (6,'(a,20l2)') 'hgenus holes not bonds  on each binder='
C     $     ,(hgenus(i),i=1,n)
C	write (6,'(a,20i2)') 'ngenus nber bonds/holes on each binder='
C     $     ,(ngenus(i),i=1,n)
 
C	write (6,'(a,20i2)') 'igenus start index for     each binder='
C     $     ,(igenus(i),i=1,n)
C	write (6,'(a,20i2)') 'genus list=',(genus(i),i=1,nsl)
C	write (6,'(a,20i2)') 'aftersites=',(aftersites(i),i=1,nsl)
C	write (6,'(a,20i2)') 'to binder  ',(getbinder(i),i=1,nsl)

	call setsmax (genus,m)

C	write (6,'(a,20i2)') 'smax       ',(smax(i),i=1,nsl)
	nslmax= max (nsl,nslmax)

	return
      end if

c     **** loop updating the ligand being varied ****

      ilig= n
      do while (.not.nextsitepattern(genus,ilig,m))
	if (ilig.le.1) then
c	  *** all genera found ****
          nextgenus= .false.
	  return
	end if
	ilig= ilig - 1
      end do
C      write (6,*) 'ligand being updated=',ilig

      return
      end

c     ******************************************************************

      subroutine setsmax (genus,m)

c     **** smax is the maximum site number that is allowed for this ligand bond ****

      implicit integer (a-z)
      parameter (mb=8)
      integer genus(16)
      logical hgenus

      common /ggenus/ nsl,nslmax,ngenus(mb),igenus(mb),hgenus(mb),
     $   genus0(16),smax(16),aftersites(16),getbinder(16),list(0:mb)

C      write (6,'(a,40i2)') ' in setsmax       genus=',(genus(i),i=1,nsl)

      if (nsl.eq.0) return

c     *** max possible value ****
      smax= m-1

c     *** first binder must go to site 0 ****
      smax(1)= 0

c     **** set up to the first ligand site that is not on Dnh symm plane ****
      i= 2
      do while (i.le.nsl .and. (genus(i).eq.0 .or. genus(i)*2.eq.m))
	smax(i)= min (m/2, m - 1 - aftersites(i))
        i= i + 1
      end do
      if (i.lt.nsl) smax(i)= min (m/2, m - 1 - aftersites(i))
      if (i.ge.nsl) smax(nsl)= m-1

c     **** set remainder forcing increasing order ****
      do j= i+1,nsl
	smax(j)= m-1 - aftersites(j)
C	write (6,*) 'setting smax:',j,smax(j)
      end do


C      write (6,'(3x,a,40i2)')   '          aftersites=',
C     $						(aftersites(j),j=1,nsl)
C      write (6,'(i3,a,40i2)')i,' smax for this genus=',(smax(j),j=1,nsl)

      return
      end

c     ******************************************************************

      function nextsitepattern (genus,ilig,m)

c     **** updates the site pattern on this ligand, false if no more ****
c     **** sites from ngenus(ilig) to ngenus(ilig) + igenus(ilig) - 1
c     **** must be in increasing order, must be less than smax entry ****

      implicit integer (a-z)
      parameter (mb=8)
      integer genus(16)
      logical hgenus,nextsitepattern
      common /ggenus/ nsl,nslmax,ngenus(mb),igenus(mb),hgenus(mb),
     $   genus0(16),smax(16),aftersites(16),getbinder(16),list(0:mb)

      if (nsl.eq.0) then
        nextsitepattern= .false.
        return
      end if

      i1= igenus(ilig)
      i2= ngenus(ilig) + igenus(ilig) - 1

C      write (6,'(a,i2,a,2i2)') 'nextsitepattern: lig=',ilig,
C     $		' range=',i1,i2
C      write (6,'(a,20i2)') 'entry to nextsitepattern, genus=',
C     $				(genus(j),j=1,nsl)
C      write (6,'(a,20i2)') 'entry to nextsitepattern, smax =',
C     $				(smax(j),j=1,nsl)
      
      i= i2
C      write (6,*) 'i1,i2=',i1,i2
      genus(i)= genus(i) + 1
      call setsmax (genus,m)
C      write (6,'(a,i4,a,2i4)') 'i=',i,' genus,smax=',genus(i),smax(i)
      do while (genus(i).gt.smax(i))
	i= i - 1
	if (i.lt.i1) then
C	  write (6,*) '        no more patterns'
	  do j= i1,i2
	     genus(j)= genus0(j)
	  end do
	  nextsitepattern= .false.
	  return
	end if
	genus(i)= genus(i) + 1
	call setsmax (genus,m)
C        write (6,*) 'new                     , smax =',(smax(j),j=1,nsl)
      end do

c     **** default pattern for binding sites after that changed ****
      do j= i+1,i2
	genus(j)= genus(i) + j-i
      end do

C      write (6,'(a,2i2)') '          pattern=',(genus(i),i=i1,i2)

      nextsitepattern= .true.
      return

      end

c     ******************************************************************

      subroutine encode1 (b,g,m,n,family,genus,ipgenus,npgenus,hpgenus)

c     **** this takes the integer array genus, simply encodes it

      implicit integer (a-z)
      parameter (mb=8)
      integer family(m),genus(16),ipgenus(mb),npgenus(mb),hpgenus(mb),b
      integer*8 g
      integer code
      logical hgenus
      common /ggenus/ nsl,nslmax,ngenus(mb),igenus(mb),hgenus(mb),
     $   genus0(16),smax(16),aftersites(16),getbinder(16),list(0:mb)
      common /eencode/ c

C      write (6,'(a,20i2)') 'encode1: ipgenus=',(ipgenus(i),i=1,n)
C      write (6,'(a,20i2)') 'encode1: npgenus=',(npgenus(i),i=1,n)

      g= 0
      b= 0

c     **** loop over binders in the order they come ****

      do ilig= 1,n

c	**** first and last site this binder bonds to ****
	i1= ipgenus(ilig)
	i2= ipgenus(ilig) + npgenus(ilig) - 1
C	write (6,'(a,2i3)') 'i1,i2=',i1,i2

c	**** sort the sites into ascending order ****
	call order (genus(i1),npgenus(ilig))
C	write (6,'(a,2i3)') 'orderes sites=',(genus(i),i=i1,i2)

c	*** encode these sites ****
	code= 0
	do i=  i1,i2
c	  **** add bond or bond hole info into site specification ****
	  k= genus(i)
	  if (hpgenus(ilig)) k= k + 8
	  code= lshft (code,c) + genus(i)
	end do

Cc	**** now order all the binders ****
C	call order (code,family(ifamily))

c	**** now insert this pattern set into the main code string ****
	g= lshft (g,npgenus(ilig)*c) + code

c	**** encode the ligand pattern too ****
	k= npgenus(ilig)
	if (hpgenus(ilig)) k= k + 8
	b= lshft (b,c) + k

      end do

      return

      end

c     ******************************************************************

      subroutine encode (g,m,n,family,genus)

c     **** this takes the integer array genus, checks for canonical ordering ****
c     **** and then encdes it into a 64-bit string of c = 3 or 4 bits per number ****

      implicit integer (a-z)
      parameter (mb=8)
      integer b,family(m),genus(16)
      integer*8 g
      integer code(mb)
      logical hgenus
      common /ggenus/ nsl,nslmax,ngenus(mb),igenus(mb),hgenus(mb),
     $   genus0(16),smax(16),aftersites(16),getbinder(16),list(0:mb)
      common /eencode/ c

C      write (6,'(a,20i2)') ' encoding genus:',(genus(i),i=1,nsl)

      g= 0
      b= 0

C     **** loop over binders with different numbers of bonds ****

      ilig= 0
      do ifamily= 1,m
	if (family(ifamily).eq.0) cycle

c	**** loop over all binders with this number of bonds ****
	do ib= 1,family(ifamily)
	  ilig= ilig + 1
	  i1= igenus(ilig)
	  i2= igenus(ilig) + ngenus(ilig) - 1

c	  **** sort the sites into ascending order ****
	  call order (genus(i1),ngenus(ilig))

c	  *** encode these sites ****
	  code(ib)= 0
	  iwid= 0
	  do i=  i1,i2
c	    **** add bond or bond hole info into site specification ****
	    k= genus(i)
	    if (hgenus(ilig)) k= k + 8
	    code(ib)= lshft (code(ib),c) + k
	    iwid= iwid + c
C	    write (6,'(a,4i2,l2,i3,z17.16)') 'fam,ilig,i,genus,hole,wid'
C     $		,ifamily,ib,i,genus(i),hgenus(ilig),iwid,code(ib)
	  end do

Cc	  **** encode the binder pattern too ****
C	  k= ngenus(ilig)
C	  if (hgenus(ilig)) k= k + 8
C	  b= lshft (b,c) + k

	end do

c	**** now order all the binders ****
	call order (code,family(ifamily))

c	**** now insert this ordered pattern set into the main code string ****
	do ib= 1,family(ifamily)
	  g= lshft (g,iwid) + code(ib)
	end do

C	write (6,'(a,20i2)')   'reordered genus:',(genus(i),i=1,nsl)
C	write (6,'(a,z9.8,z17.16)') 'code b,b=       ',b,g

      end do

      end

c     ******************************************************************

      function unmatched (g,gstor,ng,m,family)

c     **** this applies all rotation operators to g and then check its in the store ****

      implicit integer (a-z)
      parameter (mb=8)
      integer family(mb),genus(16)
      integer*8 gstor(ng),g,g1,g2
      logical hgenus,unmatched
      common /ggenus/ nsl,nslmax,ngenus(mb),igenus(mb),hgenus(mb),
     $   genus0(16),smax(16),aftersites(16),getbinder(16),list(0:mb)
      common /eencode/ c
 
C	write (6,'(2x,a,z17.16,z9.8)') ' matching code=',g

c     **** construct and test all possible site rotations ****

      do irot= 0,m-1

c	**** apply rotation, get longhand genus ****
	do j= 1,nsl
	  k= ibits (g,(j-1)*c,c)
c	  **** remove hole flag ****
	  k= mod (k,8)
	  k= mod (k+irot,m)
	  genus(nsl-j+1)= k
	end do
C	write (6,'(a,20i2)') ' genus=',(genus(i),i=1,nsl)

c	**** encode this new arrangement ****
        call encode (g1,m,n,family,genus)
C	write (6,'(i2,a,z17.16,z9.8)') irot,' rotation code=',g1

c	**** check if this already exists in list ****
	do i= 1,ng
	  if (g1.eq.gstor(i)) then
C	    write (6,'(a,i7)') 'matched to genera',i
      	    unmatched= .false.
	    return
	  end if
	end do

c	**** apply Dnh reflection operator ****
	do j= 1,nsl
	  k= ibits (g1,(j-1)*c,c)
	  k= mod (k,8)
	  k= mod (m-k,m)
	  genus(nsl-j+1)= k
	end do
	  
c	**** encode this new arrangement ****
        call encode (g2,m,n,family,genus)
C	write (6,'(i2,a,z17.16,z9.8)') irot,' refl/rot code=',g2

c	**** check if this already exists in list ****
	do i= 1,ng
	  if (g2.eq.gstor(i)) then
C	    write (6,'(a,i7)') 'matched to genera',i
      	    unmatched= .false.
	    return
	  end if
	end do

      end do

C	write (6,'(2x,a,z17.16,z9.8)') ' new      code=',g

      unmatched= .true.
      return

      end

c     ******************************************************************

      subroutine order (x,nber)

      implicit integer (a-z)
      integer x(nber)

C      write (6,*) (x(i),i=1,nber)

      do i= 1,nber
	do j= i+1,nber
	  if (x(j).lt.x(i)) then
	    kk= x(i)
	    x(i)= x(j)
	    x(j)= kk
	  end if
	end do
      end do

C      write (6,*) (x(i),i=1,nber)

      return
      end

c     ******************************************************************

      subroutine getperm (n)

      implicit integer (a-z)
      parameter (mb=8, mbp=8*7*6*5*4*3*2)
      integer a(mb)
      logical ok
      common /pperm/ perm(mb,mbp),nperm

      do i= 1,n
	a(i)= i
      end do
      ind= n
      a(ind)= a(ind) - 1
      nperm= 0

      do while (ind.gt.0)
	a(ind)= a(ind) + 1
	ok= a(ind).le.n
	j= 1
	do while (j.lt.ind .and. ok)
	  ok= a(j).ne.a(ind) 
	  j= j + 1
	end do
C	write (6,'(a,3i2,a,i2,a,l2)') 'a=',a,' ind=',ind,' OK=',ok
	if (ok) then
	  if (ind.eq.n) then
	    nperm= nperm + 1
C	    write (6,'(i6,a,20i2)') nperm,' perm=',(a(k),k=1,n)
	    do k= 1,n
	      perm(k,nperm)= a(k)
	    end do
	  else 
	    ind= ind + 1
	  end if
	else if (a(ind).gt.n) then
	  a(ind)= 0
	  ind= ind - 1
	end if
      end do

      write (6,'(a,i2,a,i9)') 'n=',n,' nperm=', nperm
      return

      end

c     ******************************************************************

      subroutine printfmat (line,nline,genus,family,m,n,
     $				ipgenus,npgenus,hpgenus)

      implicit integer (a-z)
      parameter (mb=8)
      integer family(mb),genus(16),ipgenus(mb),npgenus(mb),hpgenus(mb),
     $        nbond2site(0:mb)
      character*200 line
      logical hgenus
      common /ggenus/ nsl,nslmax,ngenus(mb),igenus(mb),hgenus(mb),
     $   genus0(16),smax(16),aftersites(16),getbinder(16),list(0:mb)

      nbond2site= 0

c     **** Peter's format with colons and mus ****

      il= 0
      do ilig= 1,n
C	write (6,'(a,i3,a,2i2,l2)') 'binder=',ilig,
C     $		' indices=',ipgenus(ilig),npgenus(ilig),hpgenus(ilig)
C	write (6,'(a,10i7)') 'genus entry=',
C     $    (genus(j),j=ipgenus(ilig),ipgenus(ilig)+npgenus(ilig)-1)

c	  **** hole indicator ****
	  if (hpgenus(ilig)) then
  	    il= il + 1
  	    line(il:il)= '\'
	  end if

c	  **** mu notation ****
          if (npgenus(ilig).le.1) then
          else if (npgenus(ilig).eq.2) then
C  	    il= il + 1
C  	    line(il:il)= 'm'
          else 
C  	    il= il + 1
C  	    line(il:il)= 'm'
C  	    il= il + 1
C  	    line(il:il)= char (ichar('A')+npgenus(ilig)-1)
          end if

c	  **** if holes, then add a bond to each site and subtract off the holes later ****
	  if (hpgenus(ilig)) then
	    do k= 0,m-1
	      nbond2site(k)= nbond2site(k) + 1
	    end do
	  end if


c	  **** list sites or site holes ****
  	  do j= ipgenus(ilig),ipgenus(ilig)+npgenus(ilig)-1
  	    il= il + 1
  	    write (line(il:il),'(i1)') genus(j)
  	    il= il + 1
  	    line(il:il)= ','

c	    **** accumulate nber of bonds to each site ****
	    if (hpgenus(ilig)) then
	      nbond2site(genus(j))= nbond2site(genus(j)) - 1
	    else
	      nbond2site(genus(j))= nbond2site(genus(j)) + 1
	    end if

  	  end do

	  if (npgenus(ilig).eq.0) il= il + 1
  	  line(il:il)= ':'

      end do

      nline= il-1

c     **** see if species satisfies site max bonding criteria ****
      do k= 0,m-1
C	write (6,'(a,3i3)') 'max bond test:',k,nbond2site(k),list(k)
	if (list(k).lt.nbond2site(k)) line= ' '
      end do

      return

      end

c     ******************************************************************

      subroutine species (line,genus,family,m,n,nstor1)

      implicit integer (a-z)
      parameter (mb=8, mgstor1=100000, mbp=8*7*6*5*4*3*2)
      integer*8 g,gstor1(mgstor1)
      integer*4 b,bstor1(mgstor1)
      integer family(mb),genus(16),genusr(16),genusrr(16),
     $	      ipgenus(mb),npgenus(mb),hpgenus(mb)
      logical hgenus,ok,dumpspecies
      character*(*) line

      common /ggenus/ nsl,nslmax,ngenus(mb),igenus(mb),hgenus(mb),
     $   genus0(16),smax(16),aftersites(16),getbinder(16),list(0:mb)

      common /pperm/ perm(mb,mbp),nperm
      common /fulldump/ dumpspecies

c     **** finds all the species for this genus ****

      nstor1= 0

C      write (6,'(a,100i1)') 'finding species for genus'
C      write (6,'(a,100i1)') 'original   =',(genus(k),k=1,nsl)
      genusr= genus

      do ireflect= 1,2

	do irot= 0,m-1
	  do i= 1,nsl
	    genusrr(i)= mod (genusr(i)+irot,m)
	  end do
C          write (6,'(a,100i1)') 'rotation   =',(genusrr(k),k=1,nsl)

	  do iperm= 1,nperm
c	    **** interchange the ligand order in genus !!! new ligand indices ****
	    nlig= 0
	    do ifamily= 1,m
	      do ilig= 1,family(ifamily)
	        nlig= nlig + 1
		ipgenus(nlig)= igenus(perm(nlig,iperm))
		npgenus(nlig)= ngenus(perm(nlig,iperm))
		hpgenus(nlig)= hgenus(perm(nlig,iperm))
	      end do
	    end do
C            write (6,'(a,100i1)') 'binder perm used=',
C     $				(perm(i,iperm),i=1,n)

	    call encode1(b,g,m,n,family,genusrr,ipgenus,npgenus,hpgenus)
C	    write (6,'(a,z9.8,z17.16)') 'b,g code generated=',b,g

c	    **** check to see if its already printed ****
	    ok= .true.
	    i= 1
	    do while (ok .and. i.le.nstor1)
	      ok= g.ne.gstor1(i) .or. b.ne.bstor1(i)
C	      if (.not.ok) write (6,'(a,i5)') 'matched',i
	      i= i + 1
	    end do

	    if (ok) then
	      nstor1= nstor1 + 1
	      gstor1(nstor1)= g
	      bstor1(nstor1)= b
C	      write (6,'(a,z9.8,z17.16,i5)')
C     $			'code stored   =',b,g,nstor1
	      call printfmat (line,nline,genusrr,family,m,n,
     $					ipgenus,npgenus,hpgenus)
	      if (dumpspecies .and. line.ne.' ') then
	        write (3,'(i6,3h:  ,a)') nstor1,line(1:nline)
	        write (6,'(i6,3h:  ,a)') nstor1,line(1:nline)
	      end if
	    end if

	  end do
	end do

c	**** do reflection ****
	do i= 1,nsl
	  genusr(i)= mod (m-genus(i),m)
	end do
C        write (6,'(a,100i1)') 'reflected  =',(genusr(k),k=1,nsl)
      end do

C      write (3,'(a,i6/)') 'Nber species for this genus=',nstor1
C      write (6,'(a,i6/)') 'Nber species for this genus=',nstor1

      return
      end
